<?php
defined('BASEPATH') or exit('No direct script access allowed');

class RashtraShilpiControllers extends CI_Controller
{

	//...............State construct............


	public function __construct()
	{
		parent::__construct();
		$this->load->library("form_validation");
		$this->load->model("StateModel");
		$this->load->model("DistrictModel");
		$this->load->model("RashtraShilpiModel");
		$this->load->library('upload');
		$this->load->library('session');
		$this->load->model("AdvertisementModel");
		$this->load->model("CategoryModel");
		

	}



	public function fetch_city()
	{


		if ($this->input->post('country_id')) {
			echo $this->DistrictModel->fetch_city($this->input->post('country_id'));
		}
	}


	//...............End construct............

	//...............State index function............





	public function login()
	{
		$result['add_top'] = $this->AdvertisementModel->manageFrontInfo(1);
	
		$this->load->view('login',$result);
		

	}

	public function change_password_loktantra_senani()
	{
		$this->load->view('loktantra_senani_header');
		//	$this->load->view('add_sub_gallery');
		$this->load->view('change_password_loktantra_senani');
		$this->load->view('front_footer');

	}

	public function forgetpassword()
	{
		$result['all_info_add_top'] = $this->AdvertisementModel->manageFrontInfo(2);
		$this->load->view('frontheader', $result);
		$this->load->view('forgetpassword');
		$this->load->view('front_footer');
	}


	public function checkLogin()
	{

		$this->load->library("form_validation");

		$this->form_validation->set_rules('mobile', 'mobile', 'required');
		$this->form_validation->set_rules('PASSWORD', 'Password', 'required');

		if ($this->form_validation->run() == true) {

			$user_name = $this->input->post('mobile');
			$pass = $this->input->post('PASSWORD');

			$result = $this->LoktantraSenaniModel->checkLogin($user_name, $pass);

			if ($result) {

				//		print_r($result); die;
				$sess_data = array(

					"isUserLoggedIn" => TRUE,
					"id" => $result['id']
				);

				$this->session->set_userdata($sess_data);

				$login_status = $this->LoktantraSenaniModel->logged_status("loktantra_senani_tb", array('login_status' => 1), array('id' => $result['id']));

				if ($login_status) {
					$this->session->set_userdata($sess_data);
					redirect('LoktantraSenaniControllers/getInfoByIdFront');
				} else {
					redirect('LoktantraSenaniControllers/loktantra_senani_login');
				}

			} else {
				//	echo "Enter your valid ID & Password.";
				$this->session->set_flashdata('msg', 'Enter your valid Mobile No. & Password..');
			}
		}
		redirect('LoktantraSenaniControllers/loktantra_senani_login');
	}



	public function logout()
	{



		$login_status = $this->LoktantraSenaniModel->logged_status("loktantra_senani_tb", array('login_status' => 0), array('id' => $this->session->userdata("id")));

		if ($login_status) {
			// print_r($sess_data); die;
			//	$this->session->unset_userdata($sess_data);
			$this->session->sess_destroy();
			redirect('LoktantraSenaniControllers/loktantra_senani_login');
		} else {
			redirect('LoktantraSenaniControllers/getInfoByIdFront');
		}
	}


	public function add_rashtra_shilpi()
	{

	
		
		$result['front_all_info'] = $this->StateModel->selectFrontInfo();

		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();		

		$this->load->view('admin/add_rashtra_shilpi', $result);
	
	}


	





	public function registration()
	{
		$result['add_top'] = $this->AdvertisementModel->manageFrontInfo(1);
			$result['front_all_info'] = $this->StateModel->selectFrontInfo();
			$result['all_cat'] = $this->CategoryModel->selectInfoFront();	

		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();	

		$this->load->view('signup', $result);
		
	}




	public function thanks()
	{
		$result['add_top'] = $this->AdvertisementModel->manageFrontInfo(1);
		
		$this->load->view('thanks',$result);
		
	}

	public function searchActive()
	{

		//	print_r($this->input->post('area_id_fk')); die;

		//$id=2;

		
		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();

		$result['all_info'] = $this->RashtraShilpiModel->selectInfoByStateandcityActive($this->input->post('State_id_fk'), $this->input->post('District_id_fk'));

		$this->load->view('admin/rashtra_shilpi_active_report', $result);



	}



	public function searchActiveReporter()
	{

		//	print_r($this->input->post('area_id_fk')); die;

		//$id=2;

		$this->load->view('admin/header_reporter');


		$result['all_info'] = $this->LoktantraSenaniModel->selectInfoByCityActive($this->session->userdata('district_id_fk'));

		$this->load->view('admin/manage_active_loktantra_senani_reporter', $result);


	}


	public function searchBlock()
	{

		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();

		$result['all_info'] = $this->RashtraShilpiModel->selectInfoByStateandcityBlock($this->input->post('State_id_fk'), $this->input->post('District_id_fk'));

		$this->load->view('admin/rashtra_shilpi_report', $result);



	}

	public function allFrontInfo()
	{

		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();
		$result['add_top'] = $this->AdvertisementModel->manageFrontInfo(1);

		$result['all_info'] = $this->RashtraShilpiModel->selectInfoByStateandcityActive($this->input->post('State_id_fk'), $this->input->post('District_id_fk'));

		$this->load->view('all_rashtra_shilpi', $result);



	}


	public function getAllShipliByCatId()
	{

		$id = $this->uri->segment(3);

		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();
		$result['add_top'] = $this->AdvertisementModel->manageFrontInfo(1);


		$result['all_info'] = $this->RashtraShilpiModel->getAllShipliByCatId($this->input->post('State_id_fk'), $this->input->post('District_id_fk'), $this->input->post('Name'), $id);


		$this->load->view('all_rashtra_shilpi', $result);
		
	


		
	}

	public function getAllShipliByCatIdSearch()
	{
		 
		

		

		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();
		$result['add_top'] = $this->AdvertisementModel->manageFrontInfo(1);


		$result['all_info'] = $this->RashtraShilpiModel->getAllShipliByCatId($this->input->post('State_id_fk'), $this->input->post('District_id_fk'), $this->input->post('Name'), $this->input->post('Cat_id'));


		$this->load->view('all_rashtra_shilpi', $result);

	

	

	}





	public function searchBlockReporter()
	{

		//	print_r($this->input->post('area_id_fk')); die;

		//$id=2;

		$this->load->view('admin/header_reporter');

		$district_id = $this->session->userdata('district_id_fk');
		//	print_r($district_id); die;

		$result['all_info'] = $this->LoktantraSenaniModel->selectInfoByCityBlock($district_id);

		$this->load->view('admin/manage_block_loktantra_senani_reporter', $result);



	}









	public function insertInfo()
	{

	


		$data = array(

			'mr_miss' => $this->input->post('Mr_miss'),
			'pita_pati' => $this->input->post('Pita_pati'),
			'NAME' => $this->input->post('Name'),
			'hindi_name' => $this->input->post('Hindi_name'),			
			'gender' => $this->input->post('Gender'),
			'father_name' => $this->input->post('Father_name'),
			'dob' => $this->input->post('Dob'),
			'dod' => $this->input->post('Dod'),			
			'prishthbhumi' => $this->input->post('Prishthbhumi'),
			'yogdan' => $this->input->post('Yogdan'),
			'state_id_fk' => $this->input->post('State_id_fk'),
			'district_id_fk' => $this->input->post('District_id_fk'),
			'cat_id_fk' => $this->input->post('Cat_id_fk'),			
			'website_link' => $this->input->post('Website_link'),
			'facebook_link' => $this->input->post('Facebook_link'),
			'instagrame_link' => $this->input->post('Instagrame_link'),
			'you_tube_link' => $this->input->post('You_tube_link'),
			'applicant_name' => $this->input->post('Applicant_name'),
			'applicant_email' => $this->input->post('Applicant_email'),
			'applicant_mobile_no' => $this->input->post('Applicant_mobile_no'),
			'applicant_whatsapp_no' => $this->input->post('Applicant_whatsapp_no'),
			'applicant_other_no' => $this->input->post('Applicant_other_no'),
			'applicant_address' => $this->input->post('Applicant_address'),	
			'PASSWORD' => $this->input->post('Password'),
		
		);

		$id = $this->RashtraShilpiModel->insertInfo('rashtra_shilpi_tb', $data);

		$this->oneUploadFiles($id);



	}


	public function oneUploadFiles($id)
	{


		$config = array(
			'upload_path' => FCPATH . "./RashtraShilpiImage/RashtraShilpiImage1/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['oneuploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['oneuploads[]']['name'] = $files['name'][$key];
			$_FILES['oneuploads[]']['type'] = $files['type'][$key];
			$_FILES['oneuploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['oneuploads[]']['error'] = $files['error'][$key];
			$_FILES['oneuploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['oneuploads[]']['name']) && !empty($_FILES['oneuploads[]']['name'])) {
				if (!$this->upload->do_upload('oneuploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['oneuploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$name = 'jpg';
					} else {
						$name = $array_a[1];
					}
					$array = array(

						'passport_img_formate' => $name
						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->RashtraShilpiModel->updateImage1($id, $array);
				}

			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);


		$this->uploadFiles2($id);


	}


	public function uploadFiles2($id)
	{


		$config = array(
			'upload_path' => FCPATH . "./RashtraShilpiImage/RashtraShilpiImage2/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['twouploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['twouploads[]']['name'] = $files['name'][$key];
			$_FILES['twouploads[]']['type'] = $files['type'][$key];
			$_FILES['twouploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['twouploads[]']['error'] = $files['error'][$key];
			$_FILES['twouploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['twouploads[]']['name']) && !empty($_FILES['twouploads[]']['name'])) {
				if (!$this->upload->do_upload('twouploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['twouploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'pramand_img_formate' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->RashtraShilpiModel->updateImage2($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		$this->uploadFiles3($id);
	}


	public function uploadFiles3($id)
	{
		$config = array(
			'upload_path' => FCPATH . "./RashtraShilpiImage/RashtraShilpiImage3/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['threeuploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['threeuploads[]']['name'] = $files['name'][$key];
			$_FILES['threeuploads[]']['type'] = $files['type'][$key];
			$_FILES['threeuploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['threeuploads[]']['error'] = $files['error'][$key];
			$_FILES['threeuploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['threeuploads[]']['name']) && !empty($_FILES['threeuploads[]']['name'])) {
				if (!$this->upload->do_upload('threeuploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['threeuploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'satyapan_img_formate' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->RashtraShilpiModel->updateImage3($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		$this->uploadFiles4($id);
	}


	public function uploadFiles4($id)
	{
		$config = array(
			'upload_path' => FCPATH . "./RashtraShilpiImage/RashtraShilpiImage4/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['fouruploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['fouruploads[]']['name'] = $files['name'][$key];
			$_FILES['fouruploads[]']['type'] = $files['type'][$key];
			$_FILES['fouruploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['fouruploads[]']['error'] = $files['error'][$key];
			$_FILES['fouruploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['fouruploads[]']['name']) && !empty($_FILES['fouruploads[]']['name'])) {
				if (!$this->upload->do_upload('fouruploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['fouruploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'gallery_img_formate' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->RashtraShilpiModel->updateImage4($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		// $this->uploadFiles5($id);

		if ($id) {
			$this->session->set_flashdata('msg', 'data inserted.');
			redirect("RashtraShilpiControllers/thanks");
		} else {
			$this->session->set_flashdata('msg', 'error...');
			redirect("RashtraShilpiControllers/thanks");
		}
	}


	public function uploadFiles5($id)
	{
		$config = array(
			'upload_path' => FCPATH . "./LoktantraSenani/LoktantraSenani5/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['fiveuploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['fiveuploads[]']['name'] = $files['name'][$key];
			$_FILES['fiveuploads[]']['type'] = $files['type'][$key];
			$_FILES['fiveuploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['fiveuploads[]']['error'] = $files['error'][$key];
			$_FILES['fiveuploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['fiveuploads[]']['name']) && !empty($_FILES['fiveuploads[]']['name'])) {
				if (!$this->upload->do_upload('fiveuploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['fiveuploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'image_formate5' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->LoktantraSenaniModel->updateImage5($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);
		$this->uploadFiles6($id);

	}

	public function uploadFiles6($id)
	{
		$config = array(
			'upload_path' => FCPATH . "./LoktantraSenani/Smarti/",
			'allowed_types' => 'pdf',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['sixuploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['sixuploads[]']['name'] = $files['name'][$key];
			$_FILES['sixuploads[]']['type'] = $files['type'][$key];
			$_FILES['sixuploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['sixuploads[]']['error'] = $files['error'][$key];
			$_FILES['sixuploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['sixuploads[]']['name']) && !empty($_FILES['sixuploads[]']['name'])) {
				if (!$this->upload->do_upload('sixuploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['sixuploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'image_formate6' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->LoktantraSenaniModel->updateImage6($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		if ($id) {
			$this->session->set_flashdata('msg', 'data inserted.');
			redirect("loktantraSenaniControllers/thanks_message");
		} else {
			$this->session->set_flashdata('msg', 'error...');
			redirect("loktantraSenaniControllers/thanks_message");
		}
	}


	public function oneUploadFilesUpdate($id, $head)
	{


		$config = array(
			'upload_path' => FCPATH . "./RashtraShilpiImage/RashtraShilpiImage1/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['oneuploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['oneuploads[]']['name'] = $files['name'][$key];
			$_FILES['oneuploads[]']['type'] = $files['type'][$key];
			$_FILES['oneuploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['oneuploads[]']['error'] = $files['error'][$key];
			$_FILES['oneuploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['oneuploads[]']['name']) && !empty($_FILES['oneuploads[]']['name'])) {
				if (!$this->upload->do_upload('oneuploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['oneuploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$name = 'jpg';
					} else {
						$name = $array_a[1];
					}
					$array = array(

						'passport_img_formate' => $name
						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->RashtraShilpiModel->updateImage1($id, $array);
				}

			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);


		$this->uploadFilesUpdate2($id, $head);


	}


	public function uploadFilesUpdate2($id, $head)
	{


		$config = array(
			'upload_path' => FCPATH . "./RashtraShilpiImage/RashtraShilpiImage2/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['twouploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['twouploads[]']['name'] = $files['name'][$key];
			$_FILES['twouploads[]']['type'] = $files['type'][$key];
			$_FILES['twouploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['twouploads[]']['error'] = $files['error'][$key];
			$_FILES['twouploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['twouploads[]']['name']) && !empty($_FILES['twouploads[]']['name'])) {
				if (!$this->upload->do_upload('twouploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['twouploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'pramand_img_formate' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->LoktantraSenaniModel->updateImage2($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		$this->uploadFilesUpdate3($id, $head);
	}


	public function uploadFilesUpdate3($id, $head)
	{
		$config = array(
			'upload_path' => FCPATH . "./RashtraShilpiImage/RashtraShilpiImage3/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['threeuploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['threeuploads[]']['name'] = $files['name'][$key];
			$_FILES['threeuploads[]']['type'] = $files['type'][$key];
			$_FILES['threeuploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['threeuploads[]']['error'] = $files['error'][$key];
			$_FILES['threeuploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['threeuploads[]']['name']) && !empty($_FILES['threeuploads[]']['name'])) {
				if (!$this->upload->do_upload('threeuploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['threeuploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'satyapan_img_formate' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->RashtraShilpiModel->updateImage3($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		$this->uploadFilesUpdate4($id, $head);
	}


	public function uploadFilesUpdate4($id, $head)
	{
		$config = array(
			'upload_path' => FCPATH . "./RashtraShilpiImage/RashtraShilpiImage4/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['fouruploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['fouruploads[]']['name'] = $files['name'][$key];
			$_FILES['fouruploads[]']['type'] = $files['type'][$key];
			$_FILES['fouruploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['fouruploads[]']['error'] = $files['error'][$key];
			$_FILES['fouruploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['fouruploads[]']['name']) && !empty($_FILES['fouruploads[]']['name'])) {
				if (!$this->upload->do_upload('fouruploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['fouruploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'gallery_img_formate' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->RashtraShilpiModel->updateImage4($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		//$this->uploadFilesUpdate5($id, $head);
		if ($head == 1) {
			if ($id) {
				$this->session->set_flashdata('msg', 'data inserted.');
				redirect("RashtraShilpiControllers/getInfoByIdFront");
			} else {
				$this->session->set_flashdata('msg', 'error...');
				redirect("RashtraShilpiControllers/getInfoByIdFront");
			}
		} else if ($head == 2) {
			if ($id) {
				$this->session->set_flashdata('msg', 'data inserted.');
				redirect("RashtraShilpiControllers/searchActiveReporter");
			} else {
				$this->session->set_flashdata('msg', 'error...');
				redirect("RashtraShilpiControllers/searchActiveReporter");
			}
		} else {
			if ($id) {
				$this->session->set_flashdata('msg', 'data inserted.');
				redirect("RashtraShilpiControllers/searchActive");
			} else {
				$this->session->set_flashdata('msg', 'error...');
				redirect("RashtraShilpiControllers/searchActive");
			}

		}
	}


	public function uploadFilesUpdate5($id, $head)
	{
		$config = array(
			'upload_path' => FCPATH . "./LoktantraSenani/LoktantraSenani5/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['fiveuploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['fiveuploads[]']['name'] = $files['name'][$key];
			$_FILES['fiveuploads[]']['type'] = $files['type'][$key];
			$_FILES['fiveuploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['fiveuploads[]']['error'] = $files['error'][$key];
			$_FILES['fiveuploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['fiveuploads[]']['name']) && !empty($_FILES['fiveuploads[]']['name'])) {
				if (!$this->upload->do_upload('fiveuploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['fiveuploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'image_formate5' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->LoktantraSenaniModel->updateImage5($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);
		$this->uploadFilesUpdate6($id, $head);

	}

	public function uploadFilesUpdate6($id, $head)
	{
		$config = array(
			'upload_path' => FCPATH . "./LoktantraSenani/Smarti/",
			'allowed_types' => 'pdf',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['sixuploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['sixuploads[]']['name'] = $files['name'][$key];
			$_FILES['sixuploads[]']['type'] = $files['type'][$key];
			$_FILES['sixuploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['sixuploads[]']['error'] = $files['error'][$key];
			$_FILES['sixuploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['sixuploads[]']['name']) && !empty($_FILES['sixuploads[]']['name'])) {
				if (!$this->upload->do_upload('sixuploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['sixuploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$image_formate = 'jpg';
					} else {
						$image_formate = $array_a[1];
					}


					$array = array(

						'image_formate6' => $image_formate

						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->LoktantraSenaniModel->updateImage6($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);


		if ($head == 1) {
			if ($id) {
				$this->session->set_flashdata('msg', 'data inserted.');
				redirect("LoktantraSenaniControllers/getInfoByIdFront");
			} else {
				$this->session->set_flashdata('msg', 'error...');
				redirect("LoktantraSenaniControllers/getInfoByIdFront");
			}
		} else if ($head == 2) {
			if ($id) {
				$this->session->set_flashdata('msg', 'data inserted.');
				redirect("LoktantraSenaniControllers/searchActiveReporter");
			} else {
				$this->session->set_flashdata('msg', 'error...');
				redirect("LoktantraSenaniControllers/searchActiveReporter");
			}
		} else {
			if ($id) {
				$this->session->set_flashdata('msg', 'data inserted.');
				redirect("LoktantraSenaniControllers/searchActive");
			} else {
				$this->session->set_flashdata('msg', 'error...');
				redirect("LoktantraSenaniControllers/searchActive");
			}

		}


	}


	public function manageActiveInfo()
	{
		$this->load->view('admin/header');
		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();

		$result['all_info'] = $this->LoktantraSenaniModel->selectActiveInfo();

		$this->load->view('admin/manage_active_loktantra_senani', $result);

	}

	public function manageBlockInfo()
	{
		$this->load->view('admin/header');
		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();

		$result['all_info'] = $this->LoktantraSenaniModel->selectBlockInfo();

		$this->load->view('admin/manage_block_loktantra_senani', $result);

	}



	



	//...............End Manage Subgallerty............

	//...............State Get ID Wise Subgallery Info ............

	function getInfoById()
	{
		$id = $this->uri->segment(3);
		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();
		$result['all_cat'] = $this->CategoryModel->selectInfoFront();
		$result['single_data'] = $this->RashtraShilpiModel->getInfoById($id);
	
		$this->load->view('admin/edit_rashtra_shilpi', $result);
	}


	function getInfoFrontById()
	{
		$id = $this->uri->segment(3);
		$result['add_top'] = $this->AdvertisementModel->manageFrontInfo(1);
	
		$result['single_data'] = $this->RashtraShilpiModel->getInfoById($id);
	
		$this->load->view('rashtra_shilpi_info', $result);
	}


	function getInfoByIdReporter()
	{
		$id = $this->uri->segment(3);
		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();
		$result['single_data'] = $this->LoktantraSenaniModel->getInfoById($id);
		$this->load->view('admin/header_reporter');
		$this->load->view('admin/edit_loktantra_seanni_reporter', $result);
	}


	function getInfoByIdFront()
	{
		//$id = $this->uri->segment(3);
		$id = $this->session->userdata("id");
		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();
		$result['single_data'] = $this->LoktantraSenaniModel->getInfoById($id);
		$this->load->view('loktantra_senani_header');
		$this->load->view('editLoktantraSeanniFront', $result);
		$this->load->view('front_footer');
	}

	function getFullInfoById()
	{
		$id = $this->uri->segment(3);
		$result['single_data'] = $this->LoktantraSenaniModel->getInfoById($id);
		$this->load->view('admin/header');
		$this->load->view('admin/loktantra_senani_info', $result);
	}



	function getFullInfoByIdReporter()
	{
		$id = $this->uri->segment(3);
		$result['single_data'] = $this->LoktantraSenaniModel->getInfoById($id);
		$this->load->view('admin/header_reporter');
		$this->load->view('admin/loktantra_senani_info_reporter', $result);
	}



	function getFullInfoByIdFront()
	{
		$id = $this->uri->segment(3);
		$result['single_data'] = $this->LoktantraSenaniModel->selectInfoFront($id);

		$result['all_info_add_top'] = $this->AdvertisementModel->manageFrontInfo(2);
		$this->load->view('frontheader', $result);
		$this->load->view('loktantra_senani_full_info', $result);
		$this->load->view('front_footer');

	}






	function getInfoByCatId()
	{
		$id = $this->uri->segment(3);
		$data['all_info_by_catid'] = $this->StaffModel->getInfoByCatId($id);

		$this->load->view('frontheader');
		$this->load->view('Faculty', $data);
		$this->load->view('front_footer');
	}
	//...............End Get ID Wise Subgallery Info ............

	//...............State Update Subgallery By ID ............


	function updateInfoById()
	{

		$id = $this->input->post('id');

		$data = array(

			'mr_miss' => $this->input->post('Mr_miss'),
			'pita_pati' => $this->input->post('Pita_pati'),
			'NAME' => $this->input->post('Name'),
			'hindi_name' => $this->input->post('Hindi_name'),			
			'gender' => $this->input->post('Gender'),
			'father_name' => $this->input->post('Father_name'),
			'dob' => $this->input->post('Dob'),
			'dod' => $this->input->post('Dod'),			
			'prishthbhumi' => $this->input->post('Prishthbhumi'),
			'yogdan' => $this->input->post('Yogdan'),
			'state_id_fk' => $this->input->post('State_id_fk'),
			'district_id_fk' => $this->input->post('District_id_fk'),
			'cat_id_fk' => $this->input->post('Cat_id_fk'),	
			'website_link' => $this->input->post('Website_link'),
			'facebook_link' => $this->input->post('Facebook_link'),
			'instagrame_link' => $this->input->post('Instagrame_link'),
			'you_tube_link' => $this->input->post('You_tube_link'),
			'applicant_name' => $this->input->post('Applicant_name'),
			'applicant_email' => $this->input->post('Applicant_email'),
			'applicant_mobile_no' => $this->input->post('Applicant_mobile_no'),
			'applicant_whatsapp_no' => $this->input->post('Applicant_whatsapp_no'),
			'applicant_other_no' => $this->input->post('Applicant_other_no'),
			'applicant_address' => $this->input->post('Applicant_address'),	
			'PASSWORD' => $this->input->post('Password'),
			'STATUS' => $this->input->post('Status')


		);
		$this->RashtraShilpiModel->updateInfoById($id, $data);

		$this->oneUploadFilesUpdate($id, $this->input->post('head'));
	}



	public function changepassword()
	{


		$id = $this->session->userdata("id");

		$data = array(
			'PASSWORD' => $this->input->post('PASSWORD')
		);


		$this->LoktantraSenaniModel->updatePasswordById($id, $data);

		redirect("LoktantraSenaniControllers/logout");

	}

	public function selectPassword()
	{


		$mobile = $this->input->post('mobile');
		$message = $this->input->post('message');

		//print_r($result); die;

		$this->LoktantraSenaniModel->mySms($mobile, $message);

		redirect("LoktantraSenaniControllers/loktantra_senani_login");

	}


	//...............End Update Subgallery By ID ............

	public function deleteInfo()
	{
		$id = $this->uri->segment(3);
		$image1 = $this->uri->segment(4);
		$image2 = $this->uri->segment(5);
		$image3 = $this->uri->segment(6);
		$image4 = $this->uri->segment(7);
		$image5 = $this->uri->segment(8);
		$image6 = $this->uri->segment(9);


		//	print_r($id); die;

		$this->LoktantraSenaniModel->deleteInfo($id, $image1, $image2, $image3, $image4, $image5, $image6);

		$this->load->view('admin/header');

		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();

		$result['all_info'] = $this->LoktantraSenaniModel->selectInfoByStateandcityBlock($this->input->post('state_id_fk'), $this->input->post('district_id_fk'));

		$this->load->view('admin/manage_block_loktantra_senani', $result);

	}



	public function deleteInfoActive()
	{
		$id = $this->uri->segment(3);
		$image1 = $this->uri->segment(4);
		$image2 = $this->uri->segment(5);
		$image3 = $this->uri->segment(6);
		$image4 = $this->uri->segment(7);
		$image5 = $this->uri->segment(8);
		$image6 = $this->uri->segment(9);


		//	print_r($id); die;

		$this->LoktantraSenaniModel->deleteInfo($id, $image1, $image2, $image3, $image4, $image5, $image6);


		$this->load->view('admin/header');

		$result['front_all_info'] = $this->StateModel->selectFrontInfo();
		$result['front_districtall_info'] = $this->DistrictModel->selectFrontInfo();

		$result['all_info'] = $this->LoktantraSenaniModel->selectInfoByStateandcityActive($this->input->post('state_id_fk'), $this->input->post('district_id_fk'));

		$this->load->view('admin/manage_active_loktantra_senani', $result);


	}


	public function deleteInfoActiveReporter()
	{
		$id = $this->uri->segment(3);
		$image1 = $this->uri->segment(4);
		$image2 = $this->uri->segment(5);
		$image3 = $this->uri->segment(6);
		$image4 = $this->uri->segment(7);
		$image5 = $this->uri->segment(8);
		$image6 = $this->uri->segment(9);


		//	print_r($id); die;

		$this->LoktantraSenaniModel->deleteInfo($id, $image1, $image2, $image3, $image4, $image5, $image6);


		$this->load->view('admin/header_reporter');

		$result['all_info'] = $this->LoktantraSenaniModel->selectInfoByCityActive($this->session->userdata('district_id_fk'));

		$this->load->view('admin/manage_active_loktantra_senan_reporter', $result);


	}

}