<?php
defined('BASEPATH') or exit('No direct script access allowed');

class CartOrderControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->library('cart');
        $this->load->model("CartOrderModel");
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $this->load->view('frontheader');
        // $this->load->view('add_sub_gallery');
        $this->load->view('order');
        $this->load->view('front_footer');
    }

    public function order()
    {
        $result['contents'] = $this->cart->contents();
        $result['all_info_cat'] = $this->CategoryModel->selectFrontInfoLetest();
        $this->load->view('frontheader', $result);
        $this->load->view('viewCart', $result);
    }

    public function pending_order_user()

    {
        $user_id = $this->session->userdata('id');
        // print_r($user_id); die;
        $result['contents'] = $this->cart->contents();
        $this->load->view('frontheader', $result);
        $result['all_info_order'] = $this->CartOrderModel->selectUserAllOrderInfo($user_id, "pending");
        $this->load->view('pending_order_user', $result);
    }

    public function complete_order_user()

    {
        $user_id = $this->session->userdata('id');
        // print_r($user_id); die;
        $result['contents'] = $this->cart->contents();

        $this->load->view('frontheader', $result);
        $result['all_info_order'] = $this->CartOrderModel->selectUserAllOrderInfo($user_id, "complete");
        $this->load->view('complete_order_user', $result);
    }

    public function pending_deshiorder_user()

    {
        $user_id = $this->session->userdata('id');
        // print_r($user_id); die;
        $result['contents'] = $this->cart->contents();
        $this->load->view('frontheader', $result);
        $result['all_info_order'] = $this->CartOrderModel->selectUserAllDeshiOrderInfo($user_id, "pending");
        $this->load->view('pending_deshiorder_user', $result);
    }

    public function complete_deshiorder_user()

    {
        $user_id = $this->session->userdata('id');
        // print_r($user_id); die;
        $result['contents'] = $this->cart->contents();
        $this->load->view('frontheader', $result);
        $result['all_info_order'] = $this->CartOrderModel->selectUserAllDeshiOrderInfo($user_id, "complete");
        $this->load->view('complete_deshiorder_user', $result);
    }

    public function complete_uploadorder_user()

    {
        $user_id = $this->session->userdata('id');
        // print_r($user_id); die;
        $result['contents'] = $this->cart->contents();
        $this->load->view('frontheader', $result);
        $result['all_info_order'] = $this->CartOrderModel->selectUserAllUploadOrderInfo($user_id, "complete");
        $this->load->view('upload_order_user', $result);
    }

    function add_qty($rowid, $price, $qty)
    {
        // print_r($qty); die;
        $amount = $price * ($qty + 1);
        $qty1 = $qty + 1;

        $data = array(
            'rowid' => $rowid,
            'amount' => $amount,
            'qty' => $qty1
        );
        $this->cart->update($data);

        redirect('CartOrderControllers/viewCart');
    }

    function minus_qty($rowid, $price, $qty)
    {
        // print_r($qty); die;
        $amount = $price * ($qty - 1);
        $qty1 = $qty - 1;

        $data = array(
            'rowid' => $rowid,
            'amount' => $amount,
            'qty' => $qty1
        );
        $this->cart->update($data);

        $result['contents'] = $this->cart->contents();
        // $this->load->view('add_sub_gallery');
        // $this->load->view('viewCart',$result);

        redirect('CartOrderControllers/viewCart', $result);
    }

    public function viewCart()
    {
        $result['contents'] = $this->cart->contents();
        $result['all_info_cat'] = $this->CategoryModel->selectFrontInfoLetest();
        $this->load->view('frontheader', $result);

        $this->load->view('viewCart', $result);
    }

    public function cart_order()
    {
        $result['contents'] = $this->cart->contents();
        // $this->load->view('add_sub_gallery');

        $this->load->view('frontheader', $result);
        $this->load->view('cart_order');
    }

    function getInfoById()
    {
        $id = $this->uri->segment(3);
        
        
        $data['single_data'] = $this->CartOrderModel->getInfoById($id);
       
        $data['all_info'] = $this->CartOrderModel->SelectItemById($id);
        
        $this->load->view('admin/order_Reciept', $data);
    }

    function getDeshiOrderInfoById()
    {
        $id = $this->uri->segment(3);
        $data['single_data'] = $this->CartOrderModel->getDeshiOrderInfoById($id);
        $data['all_info'] = $this->CartOrderModel->SelectDeshiOrderItemById($id);
        $this->load->view('admin/order_deshi_Reciept', $data);
    }

    function getUserInvoieInfoById()
    {
        $id = $this->uri->segment(3);
        $customer_id_fk = $this->uri->segment(4);
        // print_r($id); die;

        $data['single_data'] = $this->CartOrderModel->getUserInvoieInfoById($id, $customer_id_fk);
        $data['all_info'] = $this->CartOrderModel->SelectItemById($id);
        $this->load->view('user_order_Reciept', $data);
    }

    function getUserInvoieDeshiInfoById()
    {
        $id = $this->uri->segment(3);
        $customer_id_fk = $this->uri->segment(4);
        // print_r($id); die;

        $data['single_data'] = $this->CartOrderModel->getUserInvoieDeshiInfoById($id, $customer_id_fk);
        $data['all_info'] = $this->CartOrderModel->SelectDeshiOrderItemById($id);
        $this->load->view('user_deshiorder_Reciept', $data);
    }

    function updateInfoById()
    {
        $id = $this->uri->segment(3);

        $data = array(

            'STATUS' => "dispetch"
        );
        
        $this->CartOrderModel->updateInfoById($id, $data);      

        $result['all_info'] = $this->CartOrderModel->selectInfo("pending", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/pending_order_report', $result);
    }

    function updateDeshiOrderInfoById()
    {
        $id = $this->uri->segment(3);

        $data = array(

            'STATUS' => "Dispetch"
        );
        $this->CartOrderModel->updateDesiInfoById($id, $data);

        $this->load->view('admin/header');

        $result['all_info'] = $this->CartOrderModel->selectDeshiOrderInfo("pending", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/pending_deshi_order_report', $result);
    }

    function updateDispatchInfoById()
    {
        $id = $this->uri->segment(3);

        $data = array(

            'STATUS' => "complete"
        );
        $this->CartOrderModel->updateInfoById($id, $data);
       

        $result['all_info'] = $this->CartOrderModel->selectInfo("dispetch", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/dispetch_order_report', $result);
    }

    function updateDeshiOrderDispatchInfoById()
    {
        $id = $this->uri->segment(3);

        $data = array(

            'STATUS' => "complete"
        );
        $this->CartOrderModel->updateDesiInfoById($id, $data);

        $this->load->view('admin/header');

        $result['all_info'] = $this->CartOrderModel->selectDeshiOrderInfo("dispetch", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/dispatch_deshi_order_report', $result);
    }

    function updateUploadOrderInfoById()
    {
        $id = $this->uri->segment(3);

        $data = array(

            'STATUS' => "Dispetch"
        );
        $this->CartOrderModel->updateUploadOrderInfoById($id, $data);

        $this->load->view('admin/header');

        $result['all_info'] = $this->CartOrderModel->selectUploadOrderInfo("pending", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/pending_upload_image_order', $result);
    }

    function updateUploadDispatchInfoById()
    {
        $id = $this->uri->segment(3);

        $data = array(

            'STATUS' => "complete"
        );
        $this->CartOrderModel->updateUploadOrderInfoById($id, $data);

        $this->load->view('admin/header');

        $result['all_info'] = $this->CartOrderModel->selectUploadOrderInfo("pending", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/dispatch_upload_image_order', $result);
    }

    public function manageInfoPending()
    {
        $result['all_info'] = $this->CartOrderModel->selectInfo("pending", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/pending_order_report', $result);
    }

    public function manageDeshiInfoPending()
    {
        $this->load->view('admin/header');
        $result['contents'] = $this->cart->contents();

        $result['all_info'] = $this->CartOrderModel->selectDeshiOrderInfo("pending", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/pending_deshi_order_report.php', $result);
    }

    public function manageDeshiInfoDispatch()
    {
        $this->load->view('admin/header');
        $result['contents'] = $this->cart->contents();

        $result['all_info'] = $this->CartOrderModel->selectDeshiOrderInfo("Dispetch", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/dispatch_deshi_order_report.php', $result);
    }

    public function manageDeshiInfoComplete()
    {
        $this->load->view('admin/header');
        $result['contents'] = $this->cart->contents();

        $result['all_info'] = $this->CartOrderModel->selectDeshiOrderInfo("Complete", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/complete_deshi_order_report.php', $result);
    }

    public function manageUploadInfoPending()
    {
        $this->load->view('admin/header');
        $result['contents'] = $this->cart->contents();

        $result['all_info'] = $this->CartOrderModel->selectUploadOrderInfo("pending", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/pending_upload_image_order', $result);
    }

    public function manageUploadInfoDispatch()
    {
        $this->load->view('admin/header');
        $result['contents'] = $this->cart->contents();

        $result['all_info'] = $this->CartOrderModel->selectUploadOrderInfo("Dispetch", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/dispatch_upload_image_order', $result);
    }

    public function manageUploadInfoComplete()
    {
        $this->load->view('admin/header');
        $result['contents'] = $this->cart->contents();

        $result['all_info'] = $this->CartOrderModel->selectUploadOrderInfo("Complete", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/complete_upload_image_order', $result);
    }

    public function getItemById()
    {
        $this->load->view('admin/header');

        $result['all_info'] = $this->CartOrderModel->SelectItemById("dispetch", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/dispetch_order_report', $result);
    }

    public function manageInfoDispetch()    {
       

        $result['all_info'] = $this->CartOrderModel->selectInfo("dispetch", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/dispetch_order_report', $result);
    }

    public function manageInfoComplete()
    {
       

        $result['all_info'] = $this->CartOrderModel->selectInfo("complete", $this->input->post('date1'), $this->input->post('date2'));

        $this->load->view('admin/complete_order_report', $result);
    }

    function add_to_cart()
    {
        $data = array(
            'id' => $this->input->post('product_id'),
            'name' => $this->input->post('product_name'),
            'price' => $this->input->post('product_price'),
            'image' => $this->input->post('productimage'),
            'qty' => 1
        );

        // print_r($data); die;
        $this->cart->insert($data);
        echo $this->show_cart();
    }

    function show_cart()
    {
        $output = '';
        $no = 0;

        foreach ($this->cart->contents() as $items) {
            $no ++;
            $output .= '


			<tr>
				<td> <img src="http://localhost/Khandwa_Kirana/ProductImage/ProductImage1/' . $items['id'] . '.' . $items['image'] . '" alt="" title="" height="32" width="32"></td>
				<td>' . $items['name'] . '</td>
				<td>' . number_format($items['price']) . '</td>
				<td>' . $items['qty'] . '</td>
				<td>' . number_format($items['subtotal']) . '</td>
				<td>
				<button type="button" id="' . $items['rowid'] . '" class="romove_cart"><i style="font-size:24px" class="fa">&#xf00d;</i></button></td>
			</tr>
		';
        }

        $output .= '
		<tr>
			<th colspan="3" style="padding-top: 22px;">Total</th>
			<th colspan="2" style="padding-top: 22px;">' . 'Rs. ' . number_format($this->cart->total()) . '</th>
		</tr>
	';

        echo json_encode(array(
            $no,
            $output
        ));
        die();

        // return $output;
    }

    function load_cart()
    {
        echo $this->show_cart();
    }

    function delete_cart()
    {
        $data = array(
            'rowid' => $this->input->post('row_id'),
            'qty' => 0
        );
        $this->cart->update($data);
        echo $this->show_cart();
    }

    function add()
    {
        $insert_data = array(
            'id' => $this->input->post('id'),
            'name' => $this->input->post('name'),
            'price' => $this->input->post('price'),
            'image_formate' => $this->input->post('image_formate'),
            'qty' => 1
        );

        // print_r($insert_data); die;

        // print_r( $this->cart->insert($insert_data)); die;
        $this->cart->insert($insert_data);

        $result['contents'] = $this->cart->contents();
        echo json_encode($result);
    }

    function remove($rowid)
    {
        if ($rowid === "all") {
            $this->cart->destroy();
        } else {
            $data = array(
                'rowid' => $rowid,
                'qty' => 0
            );
            $this->cart->update($data);
        }
        redirect('IndexControllers/index');
    }

    function update_cart()
    {
        $cart_info = $_POST['cart'];
        foreach ($cart_info as $id => $cart) {
            $rowid = $cart['rowid'];
            $price = $cart['price'];
            $amount = $price * $cart['qty'];
            $qty = $cart['qty'];

            $data = array(
                'rowid' => $rowid,
                'price' => $price,
                'amount' => $amount,
                'qty' => $qty
            );
            $this->cart->update($data);
        }
        redirect('IndexControllers/index');
    }

    public function save_cart_order()
    {
        $amount = $this->input->post('Amount');

        $order = array(
            'order_date' => date('Y-m-d'),
            'customer_id_fk' => $this->input->post('customer_id_fk'),
            'amount' => $this->input->post('Amount'),
            'shipping_address' => $this->input->post('shipping_address'),
            'payment_mode' => $this->input->post('payment_mode')
        );
        // print_r($amount); die;

        // $ord_id = $this->billing_model->insert_order($order);

        $order_id = $this->CartOrderModel->insertOrderInfo('cart_order_tb', $order);
        // print_r($order_id); die;

        $cart = $this->cart->contents();
        // echo '<pre>';
        // print_r($cart); die('test');

        if ($cart = $this->cart->contents()) {
            foreach ($cart as $item) {
                $order_detail = array(
                    'order_id_fk' => $order_id,
                    'product_id_fk' => $item['id'],
                    'qty' => $item['qty'],
                    'price' => $item['price']
                );

                $id = $this->CartOrderModel->insert_order_detail('cart_order_item_tb', $order_detail);
            }
        }
        $this->cart->destroy();

        redirect("IndexControllers/thanks");
    }

    // ...............End Manage Subgallerty............
    public function save_App_order()
    {
        $order = array(
            'order_date' => date('Y-m-d'),
            'customer_id_fk' => $this->input->get('retailer_id_fk'),
            'amount' => $this->input->get('amount'),
            'shipping_address' => $this->input->get('shipingaddress')
            // 'payment_mode' => $this->input->get('payment_mode')
        );

        // print_r($order); die;

        $order_id = $this->CartOrderModel->insertOrderInfo('cart_order_tb', $order);

        $count = count($_GET['product_id_fk']);
        $data = array();
        $url = $_SERVER['REQUEST_URI'];
        // print_r($url);

        $host = explode('product_id_fk', $url);
        // echo '<pre>';
        // unset($host[0]);
        // print_r($host);
        // echo '<br/>'. count($host);

        for ($i = 1; $i < count($host); $i ++) {
            $product_details = explode('&', $host[$i]);

            // echo '<pre>';
            // print_r($product_details);

            $product_id = strstr($product_details[0], '=');
            $product_id = str_replace("=", "", $product_id);
            // print_r($product_id);

            $product_qty = strstr($product_details[1], '=');
            $product_qty = str_replace("=", "", $product_qty);
            // print_r($product_qty);

            $product_price = strstr($product_details[2], '=');
            $product_price = str_replace("=", "", $product_price);
            // print_r($product_price);

            $order_detail = array(
                'order_id_fk' => $order_id,
                'product_id_fk' => $product_id,
                'qty' => $product_qty,
                'price' => $product_price
            );

            $this->CartOrderModel->insert_order_detail('cart_order_item_tb', $order_detail);
        }
    }

    public function save_App_DeshiOrder()
    {
        $order = array(
            'order_date' => date('Y-m-d'),
            'customer_id_fk' => $this->input->get('id'),
            'shipping_address' => $this->input->get('address')
            // 'payment_mode' => $this->input->get('payment_mode')
        );

        // print_r($order); die;

        $order_id = $this->CartOrderModel->insertOrderInfo('deshi_kirana_order_bill', $order);

        $count = count($_GET['product_id_fk']);
        $data = array();
        $url = $_SERVER['REQUEST_URI'];
        // print_r($url);

        $host = explode('product_id_fk', $url);
        // echo '<pre>';
        // unset($host[0]);
        // print_r($host);
        // echo '<br/>'. count($host);

        for ($i = 1; $i < count($host); $i ++) {
            $product_details = explode('&', $host[$i]);

            // echo '<pre>';
            // print_r($product_details);

            $product_id = strstr($product_details[0], '=');
            $product_id = str_replace("=", "", $product_id);
            // print_r($product_id);

            $product_qty = strstr($product_details[1], '=');
            $product_qty = str_replace("=", "", $product_qty);
            // print_r($product_qty);

            $product_price = strstr($product_details[2], '=');
            $product_price = str_replace("=", "", $product_price);
            // print_r($product_price);

            $order_detail = array(
                'order_id_fk' => $order_id,
                'product_id_fk' => $product_id,
                'qty' => $product_qty,
                'remark' => $product_price
            );

            $this->CartOrderModel->insert_order_detail('deshi_kirana_order_item', $order_detail);
        }
    }

    public function save_order()
    {
        $order = array(
            'order_date' => date('Y-m-d'),
            'customer_id_fk' => $id = $this->session->userdata('id'),
            'shipping_address' => $this->input->post('shipping_address')
        );

        // print_r($order); die;

        $order_id = $this->CartOrderModel->insertOrderInfo('deshi_kirana_order_bill', $order);

        $data = array();

        $id = $this->uri->segment();
        $product_id_fk = $_POST['Product_id_fk'];
        $qty = $_POST['Qty'];
        $remark = $_POST['Remark'];

        $count = count($_POST['Product_id_fk']);

        // $count = $_POST['count'];

        // print_r($count); die;

        for ($i = 0; $i < $count; $i ++) {

            $data[$i] = array(
                'product_id_fk' => $product_id_fk[$i],
                'qty' => $qty[$i],
                'remark' => $remark[$i],
                'order_id_fk' => $order_id
            );

            // print_r($qty[$i]); die;

            if ($qty[$i] > 0) {

                $this->CartOrderModel->insert_order_detail('deshi_kirana_order_item', $data[$i]);
            }
        }

        redirect("IndexControllers/thanks");
    }

    public function deleteInfo()
    {
        $id = $this->uri->segment(3);

        // print_r($id); die;

        $this->CartOrderModel->deleteInfo($id);

        redirect("CartOrderControllers/manageInfoPending");
    }

    public function deleteDeshiInfo()
    {
        $id = $this->uri->segment(3);

        // print_r($id); die;

        $this->CartOrderModel->deleteDeshiInfo($id);

        redirect("CartOrderControllers/manageDeshiInfoPending");
    }

    public function deleteUploadOrderInfo()
    {
        $id = $this->uri->segment(3);

        // print_r($id); die;

        $this->CartOrderModel->deleteUploadOrderInfo($id);

        redirect("CartOrderControllers/manageUploadInfoPending");
    }

    // ............Upload Image Order Insert........
    public function insertUploadImageorder()
    {
        $user_id = $this->session->userdata('id');
        $data = array(
            'order_date' => date('Y-m-d'),
            'shipping_address' => $this->input->post('shipping_address'),
            'payment_mode' => $this->input->post('payment_mode'),
            'customer_id_fk' => $user_id
        );

        $id = $this->CartOrderModel->insertInfo('upload_image_order_tb', $data);

        $this->uploadFiles($id);
    }

    // ...............State insert uploadFiles............
    public function uploadFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./UploadOrderImages/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $name = 'jpg';
                    } else {
                        $name = $array_a[1];
                    }
                    $array = array(

                        'image_formate' => $name
                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->CartOrderModel->updateImageInfo($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("IndexControllers/thanks");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("SliderControllers/thanks");
        }
    }

    public function getUserAllOrderApp()
    {
        $id = $this->input->get('id');

        $result['all_order'] = $this->CartOrderModel->getUserAllOrderApp($id);

        print_r(json_encode($result));
    }

    public function pending_deshiorder_App()

    {
        $user_id = $this->input->get('id');
        // print_r($user_id); die;

        $result['all_info_order'] = $this->CartOrderModel->selectUserAllDeshiOrderInfo($user_id, "pending");
        print_r(json_encode($result));
    }

    function getUserInvoieInfoByIdApp()
    {
        $user_id = $this->input->get('id');
        // print_r($id); die;

        $result['all_info'] = $this->CardAppModel->SelectItemById($user_id);

        print_r(json_encode($result));
    }

    function getUserInvoieDeshiInfoByIdApp()
    {
        $user_id = $this->input->get('id');
        // print_r($id); die;
        $result['all_info'] = $this->CartOrderModel->SelectDeshiOrderItemById($user_id);
        print_r(json_encode($result));
    }
}
