<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ClientControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("ClientModel");
        $this->load->model("AdvertisementModel");
        $this->load->library('image_lib');
        $this->load->library('upload');
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $this->load->view('admin/add_client');
    }

    // ...............End index function............

    // ...............State insert insertGalleryInfo............
    public function insertInfo()
    {
        $data = array(

            'name' => $this->input->post('Name'),
            'post' => $this->input->post('Post')
        );

        $id = $this->ClientModel->insertInfo('client_tb', $data);

        $this->uploadFiles($id);
    }

    // ...............End insert insertGalleryInfo............

    // ...............State insert uploadFiles............
    public function uploadFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./ClientImages/",
            'allowed_types' => 'jpg|png|jpeg'
        );

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {

                    $this->upload->data();
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("ClientControllers");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("ClientControllers");
        }
    }
    
    
    // ...............State Update Subgallery By ID ............
    function updateInfoById()
    {
        $id = $this->input->post('id');
        
        $data = array(
            'name' => $this->input->post('Name'),
            'post' => $this->input->post('Post'),
            'status' => $this->input->post('Status')
        );
        $this->ClientModel->updateInfoById($id, $data);
        
        $this->uploadFilesUpdate($id);
    }
    
    

    public function uploadFilesUpdate($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./ClientImages/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $this->upload->data();                  
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("ClientControllers/manageInfo");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("ClientControllers/manageInfo");
        }
    }

    // ...............End insert uploadFiles............

    // ...............State Manage Subgallerty............
    public function manageInfo()
    {
        $result['all_info'] = $this->ClientModel->selectInfo();

        $this->load->view('admin/client_report', $result);
    }

    public function manageInfoFront()
    {
        $result['all_clint_info'] = $this->ClientModel->selectInfoFront();

        $this->load->view('admin/client_report', $result);
    }

    // ...............End Manage Subgallerty............

    // ...............State Get ID Wise Subgallery Info ............
    function getInfoById()
    {
        $id = $this->uri->segment(3);

        $data['single_data'] = $this->ClientModel->getInfoById($id);

        $this->load->view('admin/edit_client', $data);
    }

    // ...............End Get ID Wise Subgallery Info ............



    // ...............End Update Subgallery By ID ............
    public function deleteInfo()
    {
        $id = $this->uri->segment(3);     
     

        $this->ClientModel->deleteInfo($id);

        redirect("ClientControllers/manageInfo");
    }
}