<?php
defined('BASEPATH') or exit('No direct script access allowed');

class NewsControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("NewsModel");
        $this->load->library('upload');
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $this->load->view('admin/add_news');
    }

    public function insertInfo()
    {
        $data = array(

            'name' => $this->input->post('Name'),
            'link' => $this->input->post('Link')
        );

        $id = $this->NewsModel->insertInfo('news_tb', $data);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("NewsControllers");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("NewsControllers");
        }
    }


    public function manageInfo()
    {
        $result['all_info'] = $this->NewsModel->manageInfo();

        $this->load->view('admin/news_report', $result);
    }

    public function manageInfoActive()
    {
        $this->load->view('admin/header');

        $result['all_info'] = $this->NewsModel->manageActiveInfo();

        $this->load->view('admin/manage_slider', $result);
    }

    function getInfoById()
    {
        $id = $this->uri->segment(3);
        $data['single_data'] = $this->NewsModel->getInfoById($id);

        $this->load->view('admin/edit_news', $data);
    }

    function updateInfoById()
    {
        $id = $this->input->post('id');

        $data = array(
            'name' => $this->input->post('Name'),
            'link' => $this->input->post('Link'),
            'status' => $this->input->post('status')
        );
        $this->NewsModel->updateInfoById($id, $data);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("NewsControllers/manageInfo");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("NewsControllers/manageInfo");
        }
    }

    public function deleteInfo()
    {
        $id = $this->uri->segment(3);
      
        // print_r($id); die;

        $this->NewsModel->deleteInfo($id);

        redirect("NewsControllers/manageInfo");
    }
}