<?php
defined('BASEPATH') or exit('No direct script access allowed');

class SubCategoryControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("CategoryModel");
        $this->load->model("SubCategoryModel");
        $this->load->library('upload');
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $result['all_info'] = $this->CategoryModel->selectActiveInfo();

        $this->load->view('admin/add_sub_category', $result);
    }

    // ...............End index function............

    // ...............State insert insertGalleryInfo............
    public function insertInfo()
    {
        $data = array(

            'NAME' => $this->input->post('Name'),
            'cat_id_fk' => $this->input->post('Cat_id_fk')
        );

        $id = $this->SubCategoryModel->insertInfo('sub_category_tb', $data);

        $this->uploadFiles($id);
    }

    public function uploadFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./SubCategoryImages/",
            'allowed_types' => 'jpg|jpeg|png|jfif',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {

                    $uploads[] = $this->upload->data();

                    $image = base_url() . "./SubCategoryImages/" . $id . '.' . 'jpg';

                    // print_r($image).die();

                    $array = array(

                        'image_formate' => $image
                    );

                    $this->SubCategoryModel->updateImage($id, $array);
                }
            }
        }

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            redirect("SubCategoryControllers");
        } else {
            $this->session->set_flashdata('msg', 'error...');

            redirect("SubCategoryControllers");
        }
    }

    public function manageInfo()
    {
        $result['all_info'] = $this->SubCategoryModel->selectInfo();

        $this->load->view('admin/sub_category_report', $result);
    }

    public function fetch_sub_catogary()
    {
        $id = $this->input->post('category_id_fk');

        if ($id) {
            echo $this->SubCategoryModel->fetch_sub_category($id);
        }
    }

    public function manageActiveInfo()
    {
        $result['all_info_cat'] = $this->SubCategoryModel->selectActiveInfo();
    }

    public function manageInfoRegApp()
    {
        $result['all_info_cat'] = $this->SubCategoryModel->selectFrontRegInfo();

        print_r(json_encode($result));
    }

    public function manageInfoApp()
    {
        $result['all_info_cat'] = $this->SubCategoryModel->selectFrontInfo();

        print_r(json_encode($result));
    }

    public function manageLatestInfoApp()
    {
        $result['all_info_cat'] = $this->SubCategoryModel->selectLatestFrontInfo();

        print_r(json_encode($result));
    }

    // ...............End Manage Subgallerty............

    // ...............State Get ID Wise Subgallery Info ............
    function getInfoById()
    {
        $id = $this->uri->segment(3);
        $data['single_data'] = $this->SubCategoryModel->getInfoById($id);
        $data['all_info'] = $this->CategoryModel->selectActiveInfo();
        

        $this->load->view('admin/edit_sub_category', $data);
    }

    function updateInfoById()
    {
        $id = $this->input->post('id');

        $data = array(
            'NAME' => $this->input->post('Name'),
            'cat_id_fk' => $this->input->post('Cat_id_fk'),
            'STATUS' => $this->input->post('Status')
        );
        $this->SubCategoryModel->updateInfoById($id, $data);

        $this->uploadUpdateFiles($id);
    }

    public function uploadUpdateFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./SubCategoryImages/",
            'allowed_types' => 'jpg|jpeg|png|jfif',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {

                    $uploads[] = $this->upload->data();

                    $image = base_url() . "./SubCategoryImages/" . $id . '.' . 'jpg';

                    // print_r($image).die();

                    $array = array(

                        'image_formate' => $image
                    );

                    $this->SubCategoryModel->updateImage($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);
        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            redirect("SubCategoryControllers/manageInfo");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("SubCategoryControllers/manageInfo");
        }
    }

    public function deleteInfo()
    {
        $id = $this->uri->segment(3);
        $image = $this->uri->segment(4);
        // print_r($id); die;

        $this->SubCategoryModel->deleteInfo($id, $image);

        redirect("SubCategoryControllers/manageInfo");
    }
}