<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MemberControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("MemberModel");
        $this->load->model("ProfessionModel");
        $this->load->model("DistrictModel");
        $this->load->library('upload');
        $this->load->helper('url', 'form');
        $this->load->library("pagination");
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $result['all_city_info'] = $this->DistrictModel->selectActiveInfo();
        $result['all_info'] = $this->ProfessionModel->selectActiveInfo();

        $this->load->view('admin/add_member', $result);
    }

    public function registration()
    {
        $result['all_info'] = $this->CategoryModel->selectActiveInfo();

        $this->load->view('registration', $result);
    }

    public function requset_thanks()
    {
        $this->load->view('frontheader');

        $this->load->view('requset_thanks');
        $this->load->view('front_footer');
    }

    public function insertInfo()
    {
        $data = array(

            'gender' => $this->input->post('Gender'),
            'married_status' => $this->input->post('Married_status'),
            'profession_id_fk' => $this->input->post('Profession_id_fk'),
            'district_id_fk' => $this->input->post('District_id_fk'),
            'blood_group' => $this->input->post('Blood_group'),
            'name' => $this->input->post('Name'),
            'father' => $this->input->post('Father'),
            'mother' => $this->input->post('Mother'),
            'occupation' => $this->input->post('Ocupation'),
            'dob' => $this->input->post('Dob'),
            'mobile_no' => $this->input->post('Mobile'),
            'whatsapp_no' => $this->input->post('Whatsapp_no'),
            'email' => $this->input->post('Email'),
            'wife_name' => $this->input->post('Wife_name'),
            'father_in_law' => $this->input->post('Father_in_law'),
            'mother_in_law' => $this->input->post('Mother_in_law'),
            'no_of_children' => $this->input->post('No_of_children'),
            'doa' => $this->input->post('Doa'),
            'facebook_link' => $this->input->post('Facebook_link'),
            'instagram_link' => $this->input->post('Instagram_link'),
            'youtube_link' => $this->input->post('Youtube_link'),
            'address' => $this->input->post('Address'),
            'about' => $this->input->post('About')
        );

        $id = $this->MemberModel->insertInfo('member_registration', $data);

        $this->uploadFiles($id);
    }

    public function uploadFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./MemberImage/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $image_formate = 'JPG';
                    } else {
                        $image_formate = $array_a[1];
                    }

                    $array = array(

                        'image_formate' => $image_formate

                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->MemberModel->updateImage($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("MemberControllers/index");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("MemberControllers/index");
        }
    }

    public function insertInfoFront()
    {
        $data = array(

            'category_id_fk' => $this->input->post('Category_id_fk'),
            'owner_name' => $this->input->post('Owner_name'),
            'company_name' => $this->input->post('Company_name'),
            'address' => $this->input->post('Address'),
            'whatsapp_no' => $this->input->post('Whatsapp_no'),
            'mobile' => $this->input->post('Mobile'),
            'website_link' => $this->input->post('Website_link'),
            'product' => $this->input->post('Product'),
            'email' => $this->input->post('Email'),
            'facebook_link' => $this->input->post('Facebook_link'),
            'instagram_link' => $this->input->post('Instagram_link'),
            'youtube_link' => $this->input->post('Youtube_link'),
            'about' => $this->input->post('About')
        );

        $id = $this->MemberModel->insertInfo('tbl_registration', $data);

        $this->uploadFilesFront($id);
    }

    public function uploadFilesFront($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./RegistretionImage/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            // $config['file_name'] = $id;

            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {

                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    $image_formate = $array_a[1];

                    $array = array(

                        'image_formate' => $image_formate

                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->MemberModel->updateImage($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            $data['all_info'] = $this->CategoryModel->selectActiveInfo();

            $this->load->view('registration', $data);
        } else {

            $this->session->set_flashdata('msg', 'error...');

            $data['all_info'] = $this->CategoryModel->selectActiveInfo();

            $this->load->view('registration', $data);
        }
    }

    function updateInfoById()
    {
        $id = $this->input->post('Id');

        $data = array(
            'gender' => $this->input->post('Gender'),
            'married_status' => $this->input->post('Married_status'),
            'profession_id_fk' => $this->input->post('Profession_id_fk'),
            'district_id_fk' => $this->input->post('District_id_fk'),
            'blood_group' => $this->input->post('Blood_group'),
            'name' => $this->input->post('Name'),
            'father' => $this->input->post('Father'),
            'mother' => $this->input->post('Mother'),
            'occupation' => $this->input->post('Ocupation'),
            'dob' => $this->input->post('Dob'),
            'mobile_no' => $this->input->post('Mobile'),
            'whatsapp_no' => $this->input->post('Whatsapp_no'),
            'email' => $this->input->post('Email'),
            'wife_name' => $this->input->post('Wife_name'),
            'father_in_law' => $this->input->post('Father_in_law'),
            'mother_in_law' => $this->input->post('Mother_in_law'),
            'no_of_children' => $this->input->post('No_of_children'),
            'doa' => $this->input->post('Doa'),
            'facebook_link' => $this->input->post('Facebook_link'),
            'instagram_link' => $this->input->post('Instagram_link'),
            'youtube_link' => $this->input->post('Youtube_link'),
            'address' => $this->input->post('Address'),
            'about' => $this->input->post('About'),
            'STATUS' => $this->input->post('Status')
        );
        $this->MemberModel->updateInfoById($id, $data);

        $this->uploadUpdateFiles($id);
    }

    public function uploadUpdateFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./MemberImage/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $image_formate = 'jpg';
                    } else {
                        $image_formate = $array_a[1];
                    }

                    $array = array(

                        'image_formate' => $image_formate

                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->MemberModel->updateImage($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            redirect("MemberControllers/manageInfoBlock");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("MemberControllers/manageInfoBlock");
        }
    }

    // ...............End insert uploadFiles............

    // ...............State Manage Subgallerty............
    public function manageInfoBlock()
    {
        $result['all_info'] = $this->MemberModel->selectInfo('block');

        $this->load->view('admin/member_report', $result);
    }

    public function manageInfoActive()
    {
        $result['all_info'] = $this->MemberModel->selectInfo('active');

        $this->load->view('admin/member_active_report', $result);
    }

    public function manageInfoCatWise()
    {
        $id = $this->input->get('id');

        $result['all_info_user'] = $this->MemberModel->selectInfoCatWiseFront($id);

        print_r(json_encode($result));
    }

    function getInfoByCatId1()
    {
        $id = $this->uri->segment(3);
        // $result['all_info_user_a'] = $this->MemberModel->selectInfoCatWiseFront($id);
        // $result['all_gift'] = $this->GiftProductModel->selectInfoFrontLimit();
        // $result['all_info'] = $this->AdvertisementModel->manageFrontInfo(1);

        $config = array();
        $config["base_url"] = base_url() . "index.php/MemberControllers/getInfoByCatId";
        $config["total_rows"] = $this->MemberModel->get_count($id);
        ;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);

        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        $result["links"] = $this->pagination->create_links();

        // $result['all_info_user'] = $this->MemberModel->get_students($config["per_page"], $page);

        $result['all_info_user'] = $this->MemberModel->selectInfoCatWiseFrontS($config["per_page"], $page, $id);

        $this->load->view('frontheader');
        $this->load->view('all_user', $result);
        $this->load->view('front_footer');
    }

    function getInfoByCatId()
    {
        // get search string
        // print_r('check'); die;
        $search = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        $search = ($this->uri->segment(3)) ? $this->uri->segment(3) : $search;

        // pagination settings
        $config = array();
        $config['base_url'] = base_url() . "MemberControllers/getInfoByCatId/$search";
        $config['total_rows'] = $this->MemberModel->get_count($search);
        $config['per_page'] = "10";
        $config["uri_segment"] = 4;
        $choice = $config["total_rows"] / $config["per_page"];
        $config["num_links"] = floor($choice);

        // integrate bootstrap pagination
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = false;
        $config['last_link'] = false;
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['prev_link'] = 'Prev';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '</li>';
        $config['next_link'] = 'Next';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);

        $data['page'] = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        // get books list
        $data['all_info_user'] = $this->MemberModel->selectInfoCatWiseFrontS($config['per_page'], $data['page'], $search);

        $data['pagination'] = $this->pagination->create_links();

        // load view

        $this->load->view('all_clint', $data);
    }

    function getInfoById()
    {
        $id = $this->uri->segment(3);
        
        $result['all_city_info'] = $this->DistrictModel->selectActiveInfo();
        $result['all_cat_info'] = $this->ProfessionModel->selectActiveInfo();
       
        $result['single_data'] = $this->MemberModel->getInfoById($id);
        $this->load->view('admin/edit_member', $result);
    }

    function getFullById()
    {
        $id = $this->input->get('id');

        $result['single_data'] = $this->MemberModel->getInfoById($this->input->get('id'));

        print_r(json_encode($result));
    }

    function getFullInfoById()
    {
        $id = $this->uri->segment(3);

        $result['single_data'] = $this->MemberModel->getInfoById($id);
        $this->load->view('clint_web', $result);
    }

    public function deleteInfo()
    {
        $id = $this->uri->segment(3);
        $image = $this->uri->segment(4);

        // print_r($id); die;

        $this->MemberModel->deleteInfo($id, $image);

        redirect("MemberControllers/manageInfoBlock");
    }

    public function upload_img()
    {
        $image = base64_decode($this->input->post("image"));
        $image_name = md5(uniqid(rand(), true));

        $data_insert1 = array(

            'category_id_fk' => $this->input->post('category_id_fk'),
            'owner_name' => $this->input->post('owner_name'),
            'company_name' => $this->input->post('company_name'),
            'address' => $this->input->post('address'),
            'Phon_no' => $this->input->post('Phon_no'),
            'mobile' => $this->input->post('mobile'),
            'web_link' => $this->input->post('web_link'),
            'product' => $this->input->post('product')
        );

        $id = $this->MemberModel->insertInfo('tbl_registration', $data_insert1);

        // $data_insert = array('image_formate'=>$filename1);

        if ($id > 0) {

            $path = "RegistretionImage/";

            $filename = $id . '.' . 'jpg';

            $formate = "jpg";

            file_put_contents($path . $filename, $image);

            $data_insert = array(
                'image_formate' => $formate
            );

            $success = $this->MemberModel->updateInfoById($id, $data_insert);
            if ($success) {
                $b = "User Registered Successfully..";
            } else {
                $b = "Some Error Occured. Please Try Again..";
            }

            echo json_encode($b);
        }
    }

    public function upload_img_update()
    {
        $image = base64_decode($this->input->post("image"));
        $image_name = md5(uniqid(rand(), true));

        // $data_insert = array('image_formate'=>$filename1);

        $id = $this->input->post('id');

        if ($id > 0) {
            $filename = $id . '.' . 'jpg';

            $path = "DistrictMemberImage/";

            $formate = "jpg";

            if (isset($image) && ! empty($image)) {
                file_put_contents($path . $filename, $image);
            }

            $data_insert = array(
                'district_id_fk' => $this->input->post('district_id_fk'),
                'city_id_fk' => $this->input->post('city_id_fk'),
                'NAME' => $this->input->post('NAME'),
                'mobile_no' => $this->input->post('mobile_no'),
                'shop' => $this->input->post('shop'),
                'image_formate' => $formate
            );

            $success = $this->DistrictMemberModel->updateInfoById($id, $data_insert);

            if ($success) {
                $b = "User Registered Successfully..";
            } else {
                $b = "Some Error Occured. Please Try Again..";
            }

            echo json_encode($b);
        }
    }

    public function departmentdata()
    {
        $config = array();
        $config["base_url"] = base_url() . "welcome/departmentdata";
        $config["total_rows"] = $this->MemberModel->record_count();
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data["results"] = $this->MemberModel->fetch_departments($config["per_page"], $page);

        $data["links"] = $this->pagination->create_links();
        $this->load->view("departmentdata", $data);
    }
}