<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ProfessionControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("ProfessionModel");
        $this->load->library('upload');
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $this->load->view('admin/add_profession');
    }

    // ...............End index function............

    // ...............State insert insertGalleryInfo............
    public function insertInfo()
    {
        $data = array(

            'NAME' => $this->input->post('Name')
        );

        $id = $this->ProfessionModel->insertInfo('profession_tb', $data);

        $this->uploadFiles($id);
    }

    public function uploadFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./ProfessionImages/",
            'allowed_types' => 'jpg|png|',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $image_formate = 'jpg';
                    } else {
                        $image_formate = $array_a[1];
                    }

                    $array = array(

                        'image_formate' => $image_formate

                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->ProfessionModel->updateImage($id, $array);
                }
            }
        }

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            redirect("ProfessionControllers");
        } else {
            $this->session->set_flashdata('msg', 'error...');

            redirect("ProfessionControllers");
        }
    }

    public function manageInfo()
    {
        $result['all_info'] = $this->ProfessionModel->selectInfo();

        $this->load->view('admin/profession _report', $result);
    }

    public function manageActiveInfo()
    {
        $result['all_info_cat'] = $this->ProfessionModel->selectActiveInfo();
    }

    public function manageInfoRegApp()
    {
        $result['all_info_cat'] = $this->ProfessionModel->selectFrontRegInfo();

        print_r(json_encode($result));
    }

    public function manageInfoApp()
    {
        $result['all_info_cat'] = $this->ProfessionModel->selectFrontInfo();

        print_r(json_encode($result));
    }

    public function manageLatestInfoApp()
    {
        $result['all_info_cat'] = $this->ProfessionModel->selectLatestFrontInfo();

        print_r(json_encode($result));
    }

    // ...............End Manage Subgallerty............

    // ...............State Get ID Wise Subgallery Info ............
    function getInfoById()
    {
        $id = $this->uri->segment(3);
        $data['single_data'] = $this->ProfessionModel->getInfoById($id);

        $this->load->view('admin/edit_profession', $data);
    }

    function updateInfoById()
    {
        $id = $this->input->post('id');

        $data = array(
            'NAME' => $this->input->post('Name'),
            'STATUS' => $this->input->post('Status')
        );
        $this->ProfessionModel->updateInfoById($id, $data);

        $this->uploadUpdateFiles($id);
    }

    public function uploadUpdateFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./ProfessionImages/",
            'allowed_types' => 'jpg|png|',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $image_formate = 'jpg';
                    } else {
                        $image_formate = $array_a[1];
                    }

                    $array = array(

                        'image_formate' => $image_formate

                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->ProfessionModel->updateImage($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);
        $this->uploadUpdateFiles1($id);
    }

    public function uploadUpdateFiles1($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./ProfessionAddImage/",
            'allowed_types' => 'jpg|png|',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads1'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads1[]']['name'] = $files['name'][$key];
            $_FILES['uploads1[]']['type'] = $files['type'][$key];
            $_FILES['uploads1[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads1[]']['error'] = $files['error'][$key];
            $_FILES['uploads1[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads1[]']['name']) && ! empty($_FILES['uploads1[]']['name'])) {
                if (! $this->upload->do_upload('uploads1[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads1[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $image_formate = 'jpg';
                    } else {
                        $image_formate = $array_a[1];
                    }

                    $array = array(

                        'image_formate1' => $image_formate

                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->ProfessionModel->updateImage($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            redirect("ProfessionControllers/manageInfo");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("ProfessionControllers/manageInfo");
        }
    }

    // ...............End Update Subgallery By ID ............
  
    
    
    public function deleteInfo()
    {
        $id = $this->uri->segment(3);
        $image = $this->uri->segment(4);
        //	print_r($id); die;
        
        $this->ProfessionModel->deleteInfo($id, $image);
        
        redirect("ProfessionControllers/manageInfo");
    }
}