<?php
defined('BASEPATH') or exit('No direct script access allowed');

class QuestionAnswerControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("QuestionAnswerModel");
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $this->load->view('frontheader');
        // $this->load->view('add_sub_gallery');
        $this->load->view('feedback_form');
        $this->load->view('front_footer');
    }

    // ...............End index function............

    // ...............State insert Info............
    public function insertDataApp()
    {

        // print_r($this->input->get('legal_advisor_id_fk')); die;
        $data = array(

            'NAME' => $this->input->get('NAME'),
            'question' => $this->input->get('question'),
            'mobile' => $this->input->get('mobile')
        );

        $id = $this->QuestionAnswerModel->insertInfo('question_answer_tb', $data);
    }

    // ...............End insert insertGalleryInfo............

    // ............... Manage Info............
    public function manageInfo()
    {
        $result['all_info'] = $this->QuestionAnswerModel->selectInfo();

        $this->load->view('admin/question_answer_report', $result);
    }

    // ............... Manage Info For App............
    public function manageInfoApp()
    {
        $result['all_info_app'] = $this->QuestionAnswerModel->selectInfo();
        print_r(json_encode($result));
    }

    function getInfoById()
    {
        $id = $this->uri->segment(3);
        $data['getInfoById'] = $this->QuestionAnswerModel->getInfoById($id);

        $this->load->view('admin/edit_question_answer', $data);
    }

    function updateInfoById()
    {
        $id = $this->input->post('id');

        $data = array(

            'NAME' => $this->input->post('Name'),
            'question' => $this->input->post('Question'),
            'answer' => $this->input->post('Answer'),
            'mobile' => $this->input->post('Mobile'),
            'status' => $this->input->post('Status')
        );
        $this->QuestionAnswerModel->updateInfoById($id, $data);

        $result['all_info'] = $this->QuestionAnswerModel->selectInfo();

        $this->load->view('admin/question_answer_report', $result);
    }

    // ............... Delete Info ............
    public function deleteInfo()
    {
        $id = $this->uri->segment(3);

        $this->QuestionAnswerModel->deleteInfo($id);
        
        redirect("QuestionAnswerControllers/manageInfo");

       
    }
}
