<?php
defined('BASEPATH') or exit('No direct script access allowed');

class UserControllers extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("UserModel");
        $this->load->library('session');
        $this->load->library('cart');
    }

    public function index()
    {
        if ($this->session->userdata("isUserLoggedIn") == 'true') {
            redirect("LoginControllers/getHome");
        }

        $this->load->view('admin/login');
    }

    public function Userlogin()
    {
        if ($this->session->userdata("isUserLoggedIn") == 'true' && $this->session->userdata('id') != 0) {
            redirect("UserControllers/getHome");
        } else {

            $result['all_info_cat'] = $this->CategoryModel->selectFrontInfoLetest();
            $result['contents'] = $this->cart->contents();
            $this->load->view('frontheader');
            $this->load->view('user_login', $result);
        }
    }

    public function user_signup()
    {
        $result['all_info_cat'] = $this->CategoryModel->selectFrontInfoLetest();
        $result['contents'] = $this->cart->contents();
        $this->load->view('frontheader');
        $this->load->view('user_signup', $result);
    }

    public function forgot_password()
    {
        $result['all_info_cat'] = $this->CategoryModel->selectFrontInfoLetest();
        $result['contents'] = $this->cart->contents();

        $this->load->view('frontheader');
        $this->load->view('user_forgot_pass', $result);
    }

    public function get_forgot_password()
    {
        $mobile_no = $this->input->post('mobile_no');

        $data = $this->UserModel->getUserInfoByMobile($mobile_no);

        // print_r($data); die; $this->UserModel->sendSms("9826607332","suraj" );

        foreach ($data as $dto) {

            $this->UserModel->sendSms($mobile_no, $dto->PASSWORD);
            // print_r($dto->PASSWORD); die;
        }

        redirect("UserControllers/manageInfoActive");
    }

    public function get_App_forgot_password()
    {
        $mobile_no = $this->input->get('mobile');

        // print_r($mobile_no); die;

        // print_r($data); die; $this->UserModel->sendSms("9826607332","suraj" );

        $data = $this->UserModel->getUserInfoByMobile($mobile_no);

        // print_r($data); die; $this->UserModel->sendSms("9826607332","suraj" );

        foreach ($data as $dto) {

            $this->UserModel->sendSms($mobile_no, $dto->PASSWORD);
            // print_r($dto->PASSWORD);die;
        }

        $sess_data = array(

            "success" => '1'
        );

        // $this->session->set_userdata($sess_data);

        print_r(json_encode($sess_data));
    }

    public function getHome()
    {
        $id = $this->session->userdata('id');
        // print_r($id);die;

        if ($id > 0) {

            $result['contents'] = $this->cart->contents();

            // $this->load->view('add_sub_gallery');
            $result['all_info_cat'] = $this->CategoryModel->selectFrontInfoLetest();
            $this->load->view('frontheader', $result);
            $this->load->view('cart_order');
        } else {
            $result['contents'] = $this->cart->contents();

            // $this->load->view('add_sub_gallery');

            $this->load->view('frontheader');

            $this->load->view('user_login', $result);
        }

        // $this->getSessionInfoById();
    }

    function getSessionInfoById()
    {
        $id = $this->session->userdata('UserId');
        $data1['single_data_my'] = $this->LoginModel->getInfoById($id);

        // print_r($data1); die;
        $this->load->view('admin/header', $data1);
    }

    public function getUser()
    {

        // print_r($this->session->userdata("UserId")); die;
        $this->load->view('admin/header');
        $this->load->view('admin/add_admin');
    }

    public function checkLogin()
    {
        $this->load->library("form_validation");

        $this->form_validation->set_rules('mobile_no', 'phone', 'required');
        $this->form_validation->set_rules('PASSWORD', 'Password', 'required');

        if ($this->form_validation->run() == true) {

            $user_name = $this->input->post('mobile_no');
            $pass = $this->input->post('PASSWORD');

            $result = $this->UserModel->checkLogin($user_name, $pass);

            if ($result) {

                // print_r($result); die;
                $sess_data = array(
                    "isUserLoggedIn" => TRUE,
                    "id" => $result['id'],
                    "user_name" => $result['user_name'],
                    "address" => $result['address'],
                    "mobile_no" => $result['mobile_no']
                );

                $this->session->set_userdata($sess_data);

                // print_r($sess_data); die;

                $login_status = $this->UserModel->logged_status("user_table", array(
                    'login_status' => 1
                ), array(
                    'id' => $result['id']
                ));

                if ($login_status) {
                    $this->session->set_userdata($sess_data);

                    // print_r($sess_data); die;
                    redirect('UserControllers/getHome');
                } else {
                    redirect('UserControllers');
                }
            } else {
                // echo "Enter your valid ID & Password.";
                $this->session->set_flashdata('msg', 'Enter your valid ID & Password..');
            }
        }
        redirect('UserControllers/Userlogin');
    }

    public function checkAppLogin()
    {
        $this->load->library("form_validation");

        $mobile = $this->input->get('mobile');
        $pass = $this->input->get('password');

        $result = $this->UserModel->checkLogin($mobile, $pass);

        if ($result) {

            // print_r($result); die;
            $sess_data = array(
                "isUserLoggedIn" => TRUE,
                "id" => $result['id'],
                "user_name" => $result['user_name'],
                "address" => $result['address'],
                "mobile_no" => $result['mobile_no'],
                "success" => '1'
            );

            // $this->session->set_userdata($sess_data);

            print_r(json_encode($sess_data));
        }

        // print_r($sess_data); die;

        // $login_status = $this->UserModel->logged_status("user_table", array('login_status' => 1), array('id' => $result['id']));
        //
        // if($login_status){
        // $this->session->set_userdata($sess_data);
        //
        // //print_r($sess_data); die;
        // redirect('UserControllers/getHome');
        // }else{
        // redirect('UserControllers');
        // }
        //
        // }else{
        // // echo "Enter your valid ID & Password.";
        // $this->session->set_flashdata('msg', 'Enter your valid ID & Password..');
        // }
        //
        // redirect('IndexControllers/Userlogin');
    }

    public function logout()
    {
        $login_status = $this->UserModel->logged_status("user_table", array(
            'login_status' => 0
        ), array(
            'id' => $this->session->userdata("id")
        ));

        if ($login_status) {
            // print_r($sess_data); die;
            // $this->session->unset_userdata($sess_data);
            $this->session->sess_destroy();

            redirect('UserControllers/Userlogin');
        } else {
            redirect('UserControllers/getHome');
        }
    }

    public function insertCustomerInfo()
    {
        $data = array(

            'user_name' => $this->input->post('user_name'),
            'password' => $this->input->post('password'),
            'address' => $this->input->post('address'),
            'mobile_no' => $this->input->post('mobile_no')

            // 'creator_id_fk' => $this->input->post('creator_id')
        );

        $id = $this->UserModel->insertCustomerInfo('user_table', $data);
        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("UserControllers/Userlogin");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("UserControllers/Userlogin");
        }
    }

    public function insertCustomerInfoApp()
    {
        $data = array(

            'user_name' => $this->input->get('user_name'),
            'password' => $this->input->get('password'),
            'address' => $this->input->get('address'),
            'mobile_no' => $this->input->get('mobile_no')

            // 'creator_id_fk' => $this->input->post('creator_id')
        );

        $id = $this->UserModel->insertCustomerInfo('user_table', $data);

        if ($id) {

            // print_r($result); die;
            $sess_data = array(
                "success1" => '1'
            );

            // $this->session->set_userdata($sess_data);
        } else {

            $sess_data = array(
                "success1" => '0'
            );
        }

        print_r(json_encode($sess_data));
    }

    // ...............End insert insertGalleryInfo............

    // ...............State Manage Subgallerty............
    
    
    public function manageInfo()
    {
        $result['all_info'] = $this->UserModel->selectInfo();

        $this->load->view('admin/user_report', $result);
    }

    public function sendSms()
    {
        $mobile_no = $this->input->post('mobile');
        $message = $this->input->post('message');

        // print_r($mobile_no."and".$message ); die;

        // print_r($result); die;
        $this->UserModel->sendSms($mobile_no, $message);

        redirect("UserControllers/manageInfoActive");
    }

    // ...............End Manage Subgallerty............

    // ...............State Get ID Wise Subgallery Info ............
    function getUserInfoById()
    {
        $result['contents'] = $this->cart->contents();
        $id = $this->session->userdata('id');
        $data['single_data'] = $this->UserModel->getUserInfoById($id);

        $this->load->view('frontheader', $result);
        $this->load->view('update_user_profile', $data);
    }

    function getUserInfoByIdApp()
    {
        $id = $this->input->get('id');
        $result['single_data'] = $this->UserModel->getUserInfoById($id);
        print_r(json_encode($result));
    }

    // ...............End Get ID Wise Subgallery Info ............

    // ...............State Update Subgallery By ID ............
    function updateInfoById()
    {
        $id = $this->session->userdata('id');

        $data = array(
            'user_name' => $this->input->post('user_name'),
            'PASSWORD' => $this->input->post('password'),
            'mobile_no' => $this->input->post('mobile_no'),
            'address' => $this->input->post('address')
        );
        $this->UserModel->updateInfoById($id, $data);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            redirect("CartOrderControllers/pending_order_user");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("CartOrderControllers/pending_order_user");
        }
    }

    function updateInfoByIdApp()
    {
        $id = $this->input->get('id');

        $data = array(
            'PASSWORD' => $this->input->get('password')
        );

        $id = $this->UserModel->updateInfoById($id, $data);

        if ($id) {

            // print_r($result); die;
            $sess_data = array(
                "success1" => '1'
            );

            // $this->session->set_userdata($sess_data);
        } else {

            $sess_data = array(
                "success1" => '0'
            );
        }

        print_r(json_encode($sess_data));
    }

    // ...............End Update Subgallery By ID ............
    public function deleteInfo()
    {
        
      
        $id = $this->uri->segment(3); 
        // print_r($id); die;
        $this->UserModel->deleteInfo($id);
        redirect("UserControllers/manageInfo");
    }

    public function checkUserName()
    {
        $this->load->library("form_validation");

        $mobile = $this->input->get('mobile');

        $result = $this->UserModel->checkUserName($mobile);

        if ($result) {

            // print_r($result); die;
            $sess_data = array(
                "success" => '1'
            );

            // $this->session->set_userdata($sess_data);
        } else {

            $sess_data = array(
                "success" => '0'
            );
        }

        print_r(json_encode($sess_data));
    }
}
