<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . 'libraries/RestController.php';
require APPPATH . 'libraries/Format.php';

use chriskacerguis\RestServer\RestController;

class UserControllers extends RestController

{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("EventModel");
        $this->load->model("GalleryModel");
        $this->load->model("SliderModel");
        $this->load->model("QuestionAnswerModel");
        $this->load->model("AdvertisementModel");
        $this->load->model("ClientModel");
        $this->load->model("ContactModel");
        $this->load->model("NewsModel");
        $this->load->model("CategoryModel");
        $this->load->model("PlacedStudentModel");
        $this->load->model("StudentFeedbackModel");
        $this->load->model("PaperCuttingModel");
        $this->load->model("VideoModel");
        $this->load->model("ServiceInquiryModel");
        $this->load->model("CourseInquiryModel");
        $this->load->model("MemberModel");
        $this->load->model("BusinessDirectoryModel");
        $this->load->model("CourseModel");
        $this->load->model("ServicesModel");
        $this->load->model("SubCategoryModel");
        $this->load->model("ProductModel");
        $this->load->model("CartOrderModel");
        $this->load->model("UserModel");
    }

    // ...........All Slider Info..............
    public function getSliderInfo_get()
    {
        $result = $this->SliderModel->getSliderInfoActive();

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All Advertise Info..............
    public function getFrontAddInfo_get()
    {
        $result = $this->AdvertisementModel->getAddInfo(2);

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All Front PopupAdvertise Info..............
    public function getFrontPopAdd_get()
    {
        $result = $this->AdvertisementModel->getAddPopUpInfo(1);

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All New Info..............
    public function getNewsInfo_get()
    {
        $result = $this->NewsModel->manageActiveInfo();

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All Front Category Info..............
    public function getFrontCategoryInfo_get()
    {
        $result = $this->CategoryModel->getFrontLatestInfo();

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All Category Info..............
    public function getCategoryInfo_get()
    {
        $result = $this->CategoryModel->getInfoActive();

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All SubCategory Info..............
    public function getSubCategoryInfo_get($id)
    {
        $result = $this->SubCategoryModel->getSubCategoryInfoById($id);

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All Product Info..............
    public function getProductInfo_get($id)
    {
        $result = $this->ProductModel->getInfoByCatId($id);

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All Product Info..............
    public function getInfoById_get($id)
    {
        $result = $this->ProductModel->getInfoApiById($id);

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........All Video Info..............
    public function getVideo_get()
    {
        $result = $this->VideoModel->getActiveInfoApi();

        $this->response($result, RestController::HTTP_OK);
    }

    // ...........insert Feedback..............
    public function insertFeedback_post()
    {
        $data = array(

            'name' => $this->input->post('Name'),
            'mobile' => $this->input->post('Mobile'),
            'subject' => $this->input->post('Subject'),
            'message' => $this->input->post('Message')
        );

        $id = $this->ContactModel->insertFeedbackInfo('contact_tb', $data);

        if ($id > 0) {
            $this->response([
                'status' => true,
                'message' => 'Insert Feedback'
            ], RestController::HTTP_OK);
        } else {

            $this->response([
                'status' => false,
                'message' => 'Fail Feedback '
            ], RestController::HTTP_BAD_REQUEST);
        }
    }

    // ........................Insert Registation
    public function insertRegistation_post()
    {
        $mobile_no = $this->input->post('Mobile');

        $result = $this->BusinessDirectoryModel->checkMobileNo($mobile_no);

        if ($result) {

            $this->response([
                'status' => true,
                'message' => 'User Alredy Exits.'
            ], RestController::HTTP_OK);
        } else {

            $data = array(

                'category_id_fk' => $this->input->post('Category_id_fk'),
                'owner_name' => $this->input->post('Owner_name'),
                'company_name' => $this->input->post('Company_name'),
                'address' => $this->input->post('Address'),
                'whatsapp_no' => $this->input->post('Whatsapp_no'),
                'mobile' => $this->input->post('Mobile'),
                'website_link' => $this->input->post('Website_link'),
                'product' => $this->input->post('Product'),
                'email' => $this->input->post('Email'),
                'facebook_link' => $this->input->post('Facebook_link'),
                'instagram_link' => $this->input->post('Instagram_link'),
                'youtube_link' => $this->input->post('Youtube_link'),
                'about' => $this->input->post('About'),
                'password' => $this->input->post('Password'),
                'live_location' => $this->input->post('Live_location')
            );

            $id = $this->BusinessDirectoryModel->insertRegistration('tbl_registration', $data);

            $image = base64_decode($this->input->post("Image"));
            $image1 = base64_decode($this->input->post("Image1"));

            // $image_name = md5(uniqid(rand(), true));

            if ($id > 0) {

                if ($image != "") {

                    $path = "RegistretionImage/RegistretionImage_One/";

                    $filename = $id . '.' . 'jpg';
                    // $formate = "jpg";

                    file_put_contents($path . $filename, $image);
                }

                if ($image1 != "") {

                    $path1 = "RegistretionImage/RegistretionImage_Two";

                    $filename1 = $id . '.' . 'jpg';
                    // $formate = "jpg";

                    file_put_contents($path1 . $filename1, $image1);
                }

                $this->response([
                    'status' => true,
                    'message' => 'Registration Sucessfull'
                ], RestController::HTTP_OK);
            } else {

                $this->response([
                    'status' => false,
                    'message' => 'Fail Registration '
                ], RestController::HTTP_BAD_REQUEST);
            }
        }
    }

    // ........................update Registation
    public function updateRegistationInfo_post()
    {
        $image = base64_decode($this->input->post("Image"));
        $image1 = base64_decode($this->input->post("Image1"));
        // $image_name = md5(uniqid(rand(), true));

        $id = $this->input->post("Id");

        if ($id > 0) {

            $path = "RegistretionImage/RegistretionImage_One/";

            $filename = $id . '.' . 'jpg';
            // $formate = "jpg";

            file_put_contents($path . $filename, $image);

            $path1 = "RegistretionImage/RegistretionImage_Two";

            $filename1 = $id . '.' . 'jpg';
            // $formate = "jpg";

            file_put_contents($path1 . $filename1, $image1);

            $data = array(

                'category_id_fk' => $this->input->post('Category_id_fk'),
                'owner_name' => $this->input->post('Owner_name'),
                'company_name' => $this->input->post('Company_name'),
                'address' => $this->input->post('Address'),
                'whatsapp_no' => $this->input->post('Whatsapp_no'),
                'website_link' => $this->input->post('Website_link'),
                'product' => $this->input->post('Product'),
                'email' => $this->input->post('Email'),
                'facebook_link' => $this->input->post('Facebook_link'),
                'instagram_link' => $this->input->post('Instagram_link'),
                'youtube_link' => $this->input->post('Youtube_link'),
                'about' => $this->input->post('About'),
                'live_location' => $this->input->post('Live_location')
            );

            $success = $this->BusinessDirectoryModel->updateInfoByIdApp($id, $data);

            if ($success) {
                $this->response([
                    'status' => true,
                    'message' => 'Update Registation Info'
                ], RestController::HTTP_OK);
            } else {

                $this->response([
                    'status' => false,
                    'message' => 'Fail Update Registation Info '
                ], RestController::HTTP_BAD_REQUEST);
            }
        }
    }

    // ........................update Member
    public function updateMember_post()
    {
        $image = base64_decode($this->input->post("image"));
        // $image_name = md5(uniqid(rand(), true));

        $id = $this->input->post("Id");

        if ($id > 0) {

            $path = "MemberImage/";

            $filename = $id . '.' . 'jpg';

            // $formate = "jpg";

            file_put_contents($path . $filename, $image);

            $data = array(
                'gender' => $this->input->post('Gender'),
                'married_status' => $this->input->post('Married_status'),
                'profession_id_fk' => $this->input->post('Profession_id_fk'),
                'district_id_fk' => $this->input->post('District_id_fk'),
                'blood_group' => $this->input->post('Blood_group'),
                'name' => $this->input->post('Name'),
                'father' => $this->input->post('Father'),
                'mother' => $this->input->post('Mother'),
                'occupation' => $this->input->post('Ocupation'),
                'dob' => $this->input->post('Dob'),
                'mobile_no' => $this->input->post('Mobile'),
                'whatsapp_no' => $this->input->post('Whatsapp_no'),
                'email' => $this->input->post('Email'),
                'wife_name' => $this->input->post('Wife_name'),
                'father_in_law' => $this->input->post('Father_in_law'),
                'mother_in_law' => $this->input->post('Mother_in_law'),
                'no_of_children' => $this->input->post('No_of_children'),
                'doa' => $this->input->post('Doa'),
                'facebook_link' => $this->input->post('Facebook_link'),
                'instagram_link' => $this->input->post('Instagram_link'),
                'youtube_link' => $this->input->post('Youtube_link'),
                'address' => $this->input->post('Address'),
                'about' => $this->input->post('About'),
                'password' => $this->input->post('Password')
            );

            $success = $this->MemberModel->updateInfoByIdApp($id, $data);

            if ($success) {
                $this->response([
                    'status' => true,
                    'message' => 'Update Member Info'
                ], RestController::HTTP_OK);
            } else {

                $this->response([
                    'status' => false,
                    'message' => 'Fail Update Member Info '
                ], RestController::HTTP_BAD_REQUEST);
            }
        }
    }

    // ........................update Password Member
    public function updateMemberPassword_post()
    {
        $id = $this->input->post("id");

        if ($id > 0) {

            $data = array(

                'password' => $this->input->post("Password")
            );

            $success = $this->BusinessDirectoryModel->updateInfoByIdApp($id, $data);

            if ($success) {
                $this->response([
                    'status' => true,
                    'message' => 'Update Vehicle Info'
                ], RestController::HTTP_OK);
            } else {

                $this->response([
                    'status' => false,
                    'message' => 'Fail Update Vehicle Info '
                ], RestController::HTTP_BAD_REQUEST);
            }
        }
    }

    // ...........Chedck Login.........
    public function checkRegistationLogin_post()
    {
        $mobile_no = $this->input->post('Mobile_no');
        $password = $this->input->post('Password');

        $result = $this->BusinessDirectoryModel->checkAppLogin($mobile_no, $password);

        if ($result) {

            $this->response([
                'status' => true,
                "registration_id" => $result->registration_id,
                "company_name" => $result->company_name,
                'message' => 'Login Sucessfully'
            ], RestController::HTTP_OK);
        } else {

            $this->response([
                'status' => false,
                'message' => 'Login UnSucessfully',
                'id' => '0',
                'student_name' => 'NO'
            ], RestController::HTTP_OK);
        }
    }

    // ...........Chedck Login.........
    public function checkMobileNo_post()
    {
        $mobile_no = $this->input->post('Mobile_no');

        $result = $this->BusinessDirectoryModel->checkMobileNo($mobile_no);

        if ($result) {

            $this->response([
                'status' => true,
                "registration_id" => $result->registration_id,
                "company_name" => $result->company_name,
                'message' => 'Login Sucessfully'
            ], RestController::HTTP_OK);
        } else {

            $this->response([
                'status' => false,
                'message' => 'Login UnSucessfully',
                'id' => '0',
                'student_name' => 'NO'
            ], RestController::HTTP_UNAUTHORIZED);
        }
    }

    public function save_App_order_get()
    {
        $order = array(
            'order_date' => date('Y-m-d'),
            'user_id_fk' => $this->input->get('retailer_id_fk'),
            'total_amount' => $this->input->get('amount'),
            'shipping_address' => $this->input->get('shipingaddress'),
            'payment_mode' => $this->input->get('payment_mode')
        );

        // print_r($this->input->get('amount')).die();

        $order_id = $this->CartOrderModel->insertOrderInfo('cart_order_tb', $order);

        $url = $_SERVER['REQUEST_URI'];
        
        

        $host = explode('product_id_fk', $url);
        $host1 = explode('qty', $url);
        $host2 = explode('price', $url);

        for ($i = 1; $i < count($host); $i ++) {
            
            $product_details = explode('&', $host[$i]);
            $product_details1 = explode('&', $host1[$i]);
            $product_details2 = explode('&', $host2[$i]);

            // echo '<pre>';
            // print_r($product_details);

            $product_id = strstr($product_details[0], '=');
            $product_id = str_replace("=", "", $product_id);
            // print_r($product_id);

            $product_qty = strstr($product_details1[0], '=');
            $product_qty = str_replace("=", "", $product_qty);
            // print_r($product_qty);

            $product_price = strstr($product_details2[0], '=');
            $product_price = str_replace("=", "", $product_price);
            // print_r($product_price);

            $order_detail = array(
                'order_id_fk' => $order_id,
                'product_id_fk' => $product_id,
                'qty' => $product_qty,
                'price' => $product_price
            );

            $this->CartOrderModel->insert_order_detail(' cart_order_item_tb', $order_detail);
        }
        
        
        

        if ($order_id > 0) {
            $this->response([
                'status' => true,
                'message' => 'Sucessfull Inquiry'
            ], RestController::HTTP_OK);
        } else {

            $this->response([
                'status' => false,
                'message' => 'Fail Inquiry'
            ], RestController::HTTP_BAD_REQUEST);
        }
    }

    // ........................Insert Registation
    public function insertCustomer_post()
    {
        $mobile_no = $this->input->post('Mobile_no');
        
        
       // print_r( $mobile_no).die();
        $result = $this->UserModel->checkMobileNoApp($mobile_no);

        if ($result) {

            $this->response([
                'status' => true,
                'message' => 'User Alredy Exits.'
            ], RestController::HTTP_OK);
        } else {

            $data = array(

                'name' => $this->input->post('Name'),
                'address' => $this->input->post('Address'),
                'mobile_no' => $this->input->post('Mobile_no'),
                'email_id' => $this->input->post('Email_id'),
                'password' => $this->input->post('Password')
            );

            $id = $this->UserModel->insertInfoApp('user_tb', $data);

            if ($id > 0) {

                $this->response([
                    'status' => true,
                    'message' => 'Registration Sucessfull'
                ], RestController::HTTP_OK);
            } else {

                $this->response([
                    'status' => false,
                    'message' => 'Fail Registration '
                ], RestController::HTTP_BAD_REQUEST);
            }
        }
    }

    // ........................update Registation
    public function updateCustomerInfo_post()
    {
        $id = $this->input->post("Id");

        if ($id > 0) {

            $data = array(

                'name' => $this->input->post('Name'),
                'address' => $this->input->post('Address'),               
                'email_id' => $this->input->post('Email_id'),
                'password' => $this->input->post('Password')
            );

            $success = $this->UserModel->updateInfoByIdApp($id, $data);

            if ($success) {
                $this->response([
                    'status' => true,
                    'message' => 'Update Registation Info'
                ], RestController::HTTP_OK);
            } else {

                $this->response([
                    'status' => false,
                    'message' => 'Fail Update Registation Info '
                ], RestController::HTTP_BAD_REQUEST);
            }
        }
    }
    
    
    // ...........Chedck Login.........
    public function checkCustomerLogin_post()
    {
        $mobile_no = $this->input->post('Mobile_no');
        $password = $this->input->post('Password');
        
        $result = $this->UserModel->checkAppLogin($mobile_no, $password);
        
        if ($result) {
            
            $this->response([
                'status' => true,
                "id" => $result->id,
                "name" => $result->name,
                'message' => 'Login Sucessfully'
            ], RestController::HTTP_OK);
        } else {
            
            $this->response([
                'status' => false,
                'message' => 'Login UnSucessfully',
                'id' => '0',
                'name' => 'NO'
            ], RestController::HTTP_OK);
        }
    }
    
    
    // ...........All Product Info..............
    public function getInfoPendingOrder_get($id,$status)
    {
        
       // print_r( $id).die();
        $result = $this->CartOrderModel->getPendingOrderByUser($status, $id);
        
        $this->response($result, RestController::HTTP_OK);
    }
    
    
    // ...........All Product Info..............
    public function getOrderItemById_get($id)
    {
        
        // print_r( $id).die();
        $result = $this->CartOrderModel->getOrderItemById( $id);
        
        $this->response($result, RestController::HTTP_OK);
    }
    
   
}

?>